/*
 * Decompiled with CFR 0.152.
 */
package psidev.ontology_manager.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import psidev.ontology_manager.Ontology;
import psidev.ontology_manager.OntologyManager;
import psidev.ontology_manager.OntologyTermI;
import psidev.ontology_manager.impl.OboLoader;
import psidev.ontology_manager.impl.OntologyLoaderException;
import psidev.ontology_manager.impl.OntologyManagerContext;

public class OntologyManagerImpl
implements OntologyManager {
    public static final Log log = LogFactory.getLog(OntologyManagerImpl.class);
    private static final ResourceLoader LOADER = new DefaultResourceLoader();
    private Map<String, Ontology> ontologies = new HashMap<String, Ontology>();

    public OntologyManagerImpl() {
    }

    public OntologyManagerImpl(Properties cfg) throws OntologyLoaderException {
        this();
        this.loadOntologies(cfg);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully created and configured new OntologyManagerImpl.");
        }
    }

    @Override
    public Ontology putOntology(String ontologyID, Ontology ontology) {
        if (this.ontologies.containsKey(ontologyID) && log.isWarnEnabled()) {
            log.warn((Object)("Ontology with the ID '" + ontologyID + "' already exists. Overwriting!"));
        }
        return this.ontologies.put(ontologyID, ontology);
    }

    @Override
    public Set<String> getOntologyIDs() {
        return this.ontologies.keySet();
    }

    @Override
    public Ontology getOntology(String ontologyID) {
        return this.ontologies.get(ontologyID);
    }

    @Override
    public void setOntologyDirectory(File ontologyDirectory) {
        OntologyManagerContext.getInstance().setOntologyDirectory(ontologyDirectory);
    }

    @Override
    public boolean containsOntology(String ontologyID) {
        return this.ontologies.containsKey(ontologyID);
    }

    @Override
    public void loadOntologies(Properties config) throws OntologyLoaderException {
        if (config != null && !config.isEmpty()) {
            for (Object ontId : config.keySet()) {
                String key = (String)ontId;
                try {
                    URI uri = LOADER.getResource(config.getProperty(key)).getURI();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Loading ontology: ID= " + ontId + ", uri=" + uri));
                    }
                    Ontology oa = this.fetchOntology(key, "OBO", uri);
                    this.putOntology(key, oa);
                }
                catch (Throwable e) {
                    throw new OntologyLoaderException("Failed loading/parsing ontology " + key + " from " + config.getProperty(key), e);
                }
            }
        } else {
            throw new OntologyLoaderException("Ontology configuration map is missing or empty (map)!");
        }
    }

    protected Ontology fetchOntology(String ontologyID, String format, URI uri) throws OntologyLoaderException {
        Ontology oa = null;
        if ("OBO".equals(format)) {
            URL url;
            if (uri == null) {
                throw new IllegalArgumentException("The given CvSource doesn't have a URL");
            }
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("The given CvSource doesn't have a valid URL: " + uri);
            }
            OboLoader loader = new OboLoader();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing URL: " + url));
                }
                oa = loader.parseOboFile(url, ontologyID);
                oa.setName(ontologyID);
            }
            catch (Exception e) {
                throw new OntologyLoaderException("OboFile parser failed with Exception: ", e);
            }
        }
        throw new OntologyLoaderException("Unsupported ontology format: " + format);
        if (log.isInfoEnabled()) {
            log.info((Object)("Successfully created OntologyImpl from values: ontology=" + ontologyID + " format=" + format + " location=" + uri));
        }
        return oa;
    }

    @Override
    public Set<OntologyTermI> searchTermByName(String name) {
        HashSet<OntologyTermI> found = new HashSet<OntologyTermI>();
        for (String ontologyId : this.getOntologyIDs()) {
            Ontology oa = this.getOntology(ontologyId);
            for (OntologyTermI term : oa.getOntologyTerms()) {
                if (term.getPreferredName().equalsIgnoreCase(name)) {
                    found.add(term);
                    continue;
                }
                for (String syn : term.getNameSynonyms()) {
                    if (!syn.equalsIgnoreCase(name)) continue;
                    found.add(term);
                }
            }
        }
        return found;
    }

    @Override
    public OntologyTermI findTermByAccession(String acc) {
        String ontologyId;
        OntologyTermI term = null;
        Iterator<String> i$ = this.getOntologyIDs().iterator();
        while (i$.hasNext() && (term = this.getOntology(ontologyId = i$.next()).getTermForAccession(acc)) == null) {
        }
        return term;
    }
}

