/*
 * Decompiled with CFR 0.152.
 */
package psidev.ontology_manager.impl;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntologyManagerContext {
    public static final Log log = LogFactory.getLog(OntologyManagerContext.class);
    private File ontologyDirectory = new File(System.getProperty("java.io.tmpdir"));
    private boolean storeOntologiesLocally = false;
    private static ThreadLocal<OntologyManagerContext> instance = new ThreadLocal<OntologyManagerContext>(){

        @Override
        protected OntologyManagerContext initialValue() {
            return new OntologyManagerContext();
        }
    };

    public static OntologyManagerContext getInstance() {
        return instance.get();
    }

    private OntologyManagerContext() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default directory for storing ontologies set to " + this.ontologyDirectory.getAbsolutePath()));
        }
    }

    public boolean isStoreOntologiesLocally() {
        return this.storeOntologiesLocally;
    }

    public void setStoreOntologiesLocally(boolean storeOntologiesLocally) {
        this.storeOntologiesLocally = storeOntologiesLocally;
    }

    public File getOntologyDirectory() {
        return this.ontologyDirectory;
    }

    public void setOntologyDirectory(File ontologyDirectory) {
        if (ontologyDirectory == null) {
            throw new IllegalArgumentException("You must give a non null ontologyDirectory, use setStoreOntologiesLocally(boolean) to disable the long term storing.");
        }
        this.ontologyDirectory = ontologyDirectory;
        if (log.isInfoEnabled()) {
            log.info((Object)("Using ontologies cache directory : " + this.ontologyDirectory.getAbsolutePath()));
        }
    }
}

