/*
 * Decompiled with CFR 0.152.
 */
package psidev.ontology_manager.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.ontology_manager.Ontology;
import psidev.ontology_manager.impl.OntologyImpl;
import psidev.ontology_manager.impl.OntologyLoaderException;
import psidev.ontology_manager.impl.OntologyManagerContext;
import psidev.ontology_manager.impl.OntologyTermImpl;
import uk.ac.ebi.ols.loader.impl.BaseAbstractLoader;
import uk.ac.ebi.ols.loader.parser.OBOFormatParser;
import uk.ac.ebi.ols.model.interfaces.TermRelationship;
import uk.ac.ebi.ols.model.interfaces.TermSynonym;
import uk.ac.ebi.ols.model.ojb.TermBean;

public class OboLoader
extends BaseAbstractLoader {
    public static final Log log = LogFactory.getLog(OboLoader.class);
    private static final String ONTOLOGY_REGISTRY_NAME = "ontology.registry.map";

    protected void configure() {
        this.parser = new OBOFormatParser();
    }

    protected void parse(Object params) {
        try {
            Vector<String> v = new Vector<String>();
            v.add((String)params);
            ((OBOFormatParser)this.parser).configure(v);
            this.parser.parseFile();
        }
        catch (Exception e) {
            log.fatal((Object)("Parse failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private Ontology buildOntology(String ontologyID) {
        OntologyImpl ontology = new OntologyImpl();
        for (TermBean term : this.ontBean.getTerms()) {
            if ("PSI-MOD".equals(term.getNamespace()) && ("PSI-MI".equals(ontologyID) || "MI".equals(ontologyID))) continue;
            OntologyTermImpl ontologyTerm = new OntologyTermImpl(ontologyID, term.getIdentifier(), term.getName());
            Collection synonyms = term.getSynonyms();
            if (synonyms != null) {
                for (TermSynonym synonym : synonyms) {
                    ontologyTerm.getNameSynonyms().add(synonym.getSynonym());
                }
            }
            ontology.addTerm(ontologyTerm);
            if (!term.isObsolete()) continue;
            ontology.addObsoleteTerm(ontologyTerm);
        }
        for (TermBean term : this.ontBean.getTerms()) {
            if ("PSI-MOD".equals(term.getNamespace()) && ("PSI-MI".equals(ontologyID) || "MI".equals(ontologyID)) || term.getRelationships() == null) continue;
            for (TermRelationship relation : term.getRelationships()) {
                try {
                    ontology.addLink(relation.getObjectTerm().getIdentifier(), relation.getSubjectTerm().getIdentifier());
                }
                catch (NullPointerException e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Skipping terms relationship " + relation + "; " + e));
                }
            }
        }
        return ontology;
    }

    public Ontology parseOboFile(File file, String ontologyID) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " doesn't exist.");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " could not be read.");
        }
        this.configure();
        this.parse(file.getAbsolutePath());
        this.process();
        return this.buildOntology(ontologyID);
    }

    private File getRegistryFile() throws OntologyLoaderException {
        File ontologyDirectory = OntologyManagerContext.getInstance().getOntologyDirectory();
        File[] registry = ontologyDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return OboLoader.ONTOLOGY_REGISTRY_NAME.equals(pathname.getName());
            }
        });
        if (registry.length == 1) {
            File validatorRegistry = registry[0];
            return validatorRegistry;
        }
        return new File(ontologyDirectory.getAbsolutePath() + File.separator + ONTOLOGY_REGISTRY_NAME);
    }

    public Ontology parseOboFile(URL url, String ontologyID) throws OntologyLoaderException {
        if (url == null) {
            throw new IllegalArgumentException("Please give a non null URL.");
        }
        File ontologyFile = null;
        File ontologyDirectory = OntologyManagerContext.getInstance().getOntologyDirectory();
        boolean isKeepDownloadedOntologiesOnDisk = OntologyManagerContext.getInstance().isStoreOntologiesLocally();
        HashMap<URL, String> registryMap = null;
        if (isKeepDownloadedOntologiesOnDisk) {
            File registryFile;
            if (ontologyDirectory == null) {
                throw new IllegalArgumentException("Ontology directory cannot be null, please set it using OntologyManagerContext");
            }
            if (!ontologyDirectory.exists()) {
                throw new IllegalArgumentException("Ontology directory " + ontologyDirectory.getPath() + " must exist");
            }
            if (!ontologyDirectory.canWrite()) {
                throw new IllegalArgumentException("Ontology directory " + ontologyDirectory.getPath() + " must be writeable");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("User work directory: " + ontologyDirectory.getAbsolutePath()));
                log.info((Object)("keepTemporaryFile: " + OntologyManagerContext.getInstance().isStoreOntologiesLocally()));
            }
            if (null != (registryFile = this.getRegistryFile())) {
                try {
                    if (registryFile.length() > 0L) {
                        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(registryFile));
                        registryMap = (HashMap<URL, String>)ois.readObject();
                        if (registryMap != null) {
                            if (registryMap.containsKey(url)) {
                                ontologyFile = new File((String)registryMap.get(url));
                                if (ontologyFile.exists() && ontologyFile.canRead()) {
                                    if (log.isInfoEnabled()) {
                                        log.info((Object)("Reuse existing cache: " + ontologyFile.getAbsolutePath()));
                                    }
                                } else {
                                    if (log.isInfoEnabled()) {
                                        log.info((Object)("Could not find " + ontologyFile.getAbsolutePath()));
                                    }
                                    registryMap.remove(url);
                                    log.info((Object)"Saving registry file...");
                                    File f = this.getRegistryFile();
                                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
                                    oos.writeObject(registryMap);
                                    oos.flush();
                                    oos.close();
                                }
                            }
                        } else {
                            log.info((Object)"could not deserialize the Map");
                        }
                    } else {
                        log.info((Object)"The file is empty");
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Error while deserializing the map", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Error while deserializing the map", (Throwable)e);
                }
            }
        }
        try {
            if (ontologyFile == null || !ontologyFile.exists() || !ontologyFile.canRead()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading URL: " + url));
                }
                URLConnection con = url.openConnection();
                long size = con.getContentLength();
                if (log.isInfoEnabled()) {
                    log.info((Object)("size = " + size));
                }
                InputStream is = url.openStream();
                if (!ontologyDirectory.exists() && !ontologyDirectory.mkdirs()) {
                    throw new IOException("Cannot create temp directory: " + ontologyDirectory.getAbsolutePath());
                }
                String name = null;
                String filename = url.getFile();
                int idx = filename.lastIndexOf(47);
                if (idx != -1) {
                    name = filename.substring(idx + 1, filename.length());
                    name = name.replaceAll("[.,;:&^%$@*?=]", "_");
                } else {
                    name = "unknown";
                }
                ontologyFile = new File(ontologyDirectory + File.separator + name + System.currentTimeMillis() + ".obo");
                if (!isKeepDownloadedOntologiesOnDisk) {
                    log.info((Object)"Request file to be deleted on exit.");
                    ontologyFile.deleteOnExit();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The OBO file will be temporary stored as: " + ontologyFile.getAbsolutePath()));
                }
                FileOutputStream out = new FileOutputStream(ontologyFile);
                if (size == -1L) {
                    size = 0x40000000L;
                }
                ReadableByteChannel source = Channels.newChannel(is);
                size = out.getChannel().transferFrom(source, 0L, size);
                if (log.isInfoEnabled()) {
                    log.info((Object)(size + " bytes downloaded"));
                }
                is.close();
                out.flush();
                out.close();
                if (isKeepDownloadedOntologiesOnDisk) {
                    if (registryMap == null) {
                        registryMap = new HashMap<URL, String>();
                    }
                    registryMap.put(url, ontologyFile.getAbsolutePath());
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Serializing Map");
                    }
                    File f = this.getRegistryFile();
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
                    oos.writeObject(registryMap);
                    oos.flush();
                    oos.close();
                }
            }
            if (ontologyFile == null) {
                log.error((Object)"The ontology file is still null...");
            }
            return this.parseOboFile(ontologyFile, ontologyID);
        }
        catch (IOException e) {
            throw new OntologyLoaderException("Error while loading URL (" + url + ")", e);
        }
    }
}

