/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.ws;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.validator.api.Identifier;
import org.biopax.validator.api.Validator;
import org.biopax.validator.api.ValidatorUtils;
import org.biopax.validator.api.beans.Behavior;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.api.beans.ValidatorResponse;
import org.biopax.validator.impl.IdentifierImpl;
import org.biopax.validator.utils.Normalizer;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
public class ValidatorController {
    static final Log log = LogFactory.getLog(ValidatorController.class);
    private Validator validator;
    private static final DefaultResourceLoader LOADER = new DefaultResourceLoader();
    private static final String NEWLINE = System.getProperty("line.separator");

    public ValidatorController() {
    }

    public ValidatorController(Validator validator) {
        this.validator = validator;
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    public void check(Model model) {
        Normalizer normalizer = new Normalizer();
        normalizer.setInferPropertyDataSource(false);
        normalizer.setInferPropertyOrganism(false);
        model.addAttribute("normalizer", (Object)normalizer);
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.POST})
    public String check(HttpServletRequest request, Model mvcModel, Writer writer, @RequestParam(required=false) String url, @RequestParam(required=false) String retDesired, @RequestParam(required=false) Boolean autofix, @RequestParam(required=false) Behavior filter, @RequestParam(required=false) Integer maxErrors, @RequestParam(required=false) String profile, @ModelAttribute(value="normalizer") Normalizer normalizer) throws IOException {
        UrlResource resource = null;
        ValidatorResponse validatorResponse = new ValidatorResponse();
        if (url != null && url.length() > 0) {
            if (url != null) {
                log.info((Object)("url : " + url));
            }
            try {
                resource = new UrlResource(url);
            }
            catch (MalformedURLException e) {
                mvcModel.addAttribute("error", (Object)e.toString());
                return "check";
            }
            try {
                Validation v = this.execute((Resource)resource, resource.getDescription(), maxErrors, autofix, filter, profile, normalizer);
                validatorResponse.addValidationResult(v);
            }
            catch (Exception e) {
                return this.errorResponse(mvcModel, "check", "Exception: " + e);
            }
        }
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Map files = multiRequest.getFileMap();
            Assert.state((!files.isEmpty() ? 1 : 0) != 0, (String)"No files to validate");
            for (Object o : files.values()) {
                MultipartFile file = (MultipartFile)o;
                String filename = file.getOriginalFilename();
                if (file.getBytes().length == 0 || filename == null || "".equals(filename)) continue;
                log.info((Object)("check : " + filename));
                resource = new ByteArrayResource(file.getBytes());
                try {
                    Validation v = this.execute((Resource)resource, filename, maxErrors, autofix, filter, profile, normalizer);
                    validatorResponse.addValidationResult(v);
                }
                catch (Exception e) {
                    return this.errorResponse(mvcModel, "check", "Exception: " + e);
                }
            }
        } else {
            return this.errorResponse(mvcModel, "check", "No BioPAX input source provided!");
        }
        if ("xml".equalsIgnoreCase(retDesired)) {
            ValidatorUtils.write((ValidatorResponse)validatorResponse, (Writer)writer, null);
        } else {
            if ("html".equalsIgnoreCase(retDesired)) {
                mvcModel.addAttribute("response", (Object)validatorResponse);
                return "groupByCodeResponse";
            }
            for (Validation result : validatorResponse.getValidationResult()) {
                if (result.getModelData() != null) {
                    writer.write(result.getModelData() + NEWLINE);
                    continue;
                }
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF></rdf:RDF>" + NEWLINE);
            }
        }
        return null;
    }

    private Validation execute(Resource biopaxResource, String resultName, Integer maxErrors, Boolean autofix, Behavior errorLevel, String profile, Normalizer normalizer) throws IOException {
        int errMax = 0;
        if (maxErrors != null) {
            errMax = maxErrors;
            log.info((Object)("Limiting max no. errors to " + maxErrors));
        }
        boolean isFix = Boolean.TRUE.equals(autofix);
        Validation validationResult = new Validation((Identifier)new IdentifierImpl(), resultName, isFix, errorLevel, errMax, profile);
        this.validator.importModel(validationResult, biopaxResource.getInputStream());
        this.validator.validate(validationResult);
        this.validator.getResults().remove(validationResult);
        if (isFix && normalizer != null) {
            org.biopax.paxtools.model.Model m = (org.biopax.paxtools.model.Model)validationResult.getModel();
            normalizer.normalize(m);
            validationResult.setModelData(SimpleIOHandler.convertToOwl((org.biopax.paxtools.model.Model)m));
        }
        return validationResult;
    }

    private String errorResponse(Model model, String viewName, String msg) {
        model.addAttribute("error", (Object)msg);
        return viewName;
    }

    @RequestMapping(value={"/schema"})
    public void getSchema(Writer writer, HttpServletResponse response) throws IOException {
        log.debug((Object)"XML Schema requested.");
        BufferedReader bis = new BufferedReader(new InputStreamReader(LOADER.getResource("classpath:validator-response-2.0.xsd").getInputStream(), "UTF-8"));
        response.setContentType("application/xml");
        String line = null;
        while ((line = bis.readLine()) != null) {
            writer.write(line + NEWLINE);
        }
    }
}

