/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.biopax.validator.jaxb.Behavior;
import org.biopax.validator.jaxb.ValidatorResponse;

public class BiopaxValidatorClient {
    private static final Log log = LogFactory.getLog(BiopaxValidatorClient.class);
    public static final String DEFAULT_VALIDATOR_URL = "http://www.biopax.org/validator/check.html";
    public static final String JVM_PROPERTY_URL = "biopax.validator.url";
    private String url;

    public BiopaxValidatorClient(String url) {
        this.url = url == null || url.isEmpty() ? DEFAULT_VALIDATOR_URL : url;
        this.url = System.getProperty(JVM_PROPERTY_URL, this.url);
        try {
            this.url = this.location(this.url);
        }
        catch (IOException e) {
            log.warn((Object)("Failed to resolve to actual web service URL using: " + url + " (if there is a 301/302/307 HTTP redirect, " + "then validation requests (using HTTP POST method) will probably fail...)"), (Throwable)e);
        }
    }

    public BiopaxValidatorClient() {
        this(null);
    }

    public void validate(boolean autofix, String profile, RetFormat retFormat, Behavior filterBy, Integer maxErrs, String biopaxUrl, File[] biopaxFiles, OutputStream out) throws IOException {
        String line;
        MultipartEntityBuilder meb = MultipartEntityBuilder.create();
        meb.setCharset(Charset.forName("UTF-8"));
        if (autofix) {
            meb.addTextBody("autofix", "true");
        }
        if (profile != null && !profile.isEmpty()) {
            meb.addTextBody("profile", profile);
        }
        if (retFormat != null) {
            meb.addTextBody("retDesired", retFormat.toString().toLowerCase());
        }
        if (filterBy != null) {
            meb.addTextBody("filter", filterBy.toString());
        }
        if (maxErrs != null && maxErrs > 0) {
            meb.addTextBody("maxErrors", maxErrs.toString());
        }
        if (biopaxFiles != null && biopaxFiles.length > 0) {
            for (File f : biopaxFiles) {
                meb.addBinaryBody("file", f, ContentType.MULTIPART_FORM_DATA, f.getName());
            }
        } else if (biopaxUrl != null) {
            meb.addTextBody("url", biopaxUrl);
        } else {
            log.error((Object)"Nothing to do (no BioPAX data specified)!");
            return;
        }
        HttpEntity httpEntity = meb.build();
        String content = Executor.newInstance().execute(Request.Post((String)this.url).body(httpEntity)).returnContent().asString();
        BufferedReader res = new BufferedReader(new StringReader(content));
        PrintWriter writer = new PrintWriter(out);
        while ((line = res.readLine()) != null) {
            writer.println(line);
        }
        writer.flush();
        res.close();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public static ValidatorResponse unmarshal(String xml) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.biopax.validator.jaxb");
        Unmarshaller un = jaxbContext.createUnmarshaller();
        StreamSource src = new StreamSource(new StringReader(xml));
        ValidatorResponse resp = (ValidatorResponse)un.unmarshal((Source)src, ValidatorResponse.class).getValue();
        return resp;
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length == 0) {
            System.err.println("Available parameters: \n<path> <output> [xml|html|biopax] [auto-fix] [only-errors] [maxerrors=n] [notstrict]\n\t- validate a BioPAX file/directory (up to ~25MB in total size, -\n\totherwise, please use the biopax-validator.jar instead)\n\tin the directory using the online BioPAX Validator service\n\t(generates html or xml report, or gets the processed biopax\n\t(cannot fix all errros though) see http://www.biopax.org/validator)");
            System.exit(-1);
        }
        String input = argv[0];
        String output = argv[1];
        File fileOrDir = new File(input);
        if (!fileOrDir.canRead()) {
            System.err.println("Cannot read from " + input);
            System.exit(-1);
        }
        if (output == null || output.isEmpty()) {
            System.err.println("No output file specified (for the validation report).");
            System.exit(-1);
        }
        RetFormat outf = RetFormat.HTML;
        boolean fix = false;
        Integer maxErrs = null;
        Behavior level = null;
        String profile = null;
        for (int i = 2; i < argv.length; ++i) {
            if ("html".equalsIgnoreCase(argv[i])) {
                outf = RetFormat.HTML;
                continue;
            }
            if ("xml".equalsIgnoreCase(argv[i])) {
                outf = RetFormat.XML;
                continue;
            }
            if ("biopax".equalsIgnoreCase(argv[i])) {
                outf = RetFormat.OWL;
                continue;
            }
            if ("auto-fix".equalsIgnoreCase(argv[i])) {
                fix = true;
                continue;
            }
            if ("only-errors".equalsIgnoreCase(argv[i])) {
                level = Behavior.ERROR;
                continue;
            }
            if (argv[i].toLowerCase().startsWith("maxerrors=")) {
                String num = argv[i].substring(10);
                maxErrs = Integer.valueOf(num);
                continue;
            }
            if (!"notstrict".equalsIgnoreCase(argv[i])) continue;
            profile = "notstrict";
        }
        HashSet<File> files = new HashSet<File>();
        if (fileOrDir.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".owl");
                }
            };
            for (String s : fileOrDir.list(filter)) {
                files.add(new File(fileOrDir.getCanonicalPath() + File.separator + s));
            }
        } else {
            files.add(fileOrDir);
        }
        if (!files.isEmpty()) {
            BiopaxValidatorClient val = new BiopaxValidatorClient();
            val.validate(fix, profile, outf, level, maxErrs, null, files.toArray(new File[0]), new FileOutputStream(output));
        }
    }

    private String location(String url) throws IOException {
        String location = url;
        String loc = url;
        for (int i = 0; loc != null && i < 5; ++i) {
            if ((loc = (String)Request.Post((String)loc).execute().handleResponse((ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                    Header header = httpResponse.getLastHeader("Location");
                    return header != null ? header.getValue().trim() : null;
                }
            })) == null) continue;
            location = loc;
            log.info((Object)("BioPAX Validator location: " + loc));
        }
        return location;
    }

    public static enum RetFormat {
        HTML,
        XML,
        OWL;

    }
}

